
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tomato_paste")

# Create variables
x = m.addVar(lb=0, name="cherry_tomatoes")
y = m.addVar(lb=0, name="cocktail_tomatoes")

# Set objective function
m.setObjective(3*x + 4*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 2.5*y >= 350, "sugar_constraint")
m.addConstr(1.5*x + 3*y >= 250, "acid_constraint")

# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Minimum cost: ${m.objVal}")
    print(f"Cherry tomatoes: {x.x} units")
    print(f"Cocktail tomatoes: {y.x} units")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

