
from gurobipy import *

# Create a new model
m = Model("Tomato_Paste_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry_tomatoes")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cocktail_tomatoes")

# Set the objective function
m.setObjective(3*x + 4*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 2.5*y >= 350, "sugar_constraint")
m.addConstr(1.5*x + 3*y >= 250, "acid_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cherry tomatoes: {x.x}")
    print(f"Cocktail tomatoes: {y.x}")
    print(f"Minimum cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")

