
import gurobi

def solve_tomato_paste_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="cherry_tomatoes", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="cocktail_tomatoes", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize the total cost
    model.setObjective(3*x + 4*y, gurobi.GRB.MINIMIZE)

    # Sugar requirement constraint
    model.addConstr(5*x + 2.5*y >= 350, name="sugar_requirement")

    # Acid requirement constraint
    model.addConstr(1.5*x + 3*y >= 250, name="acid_requirement")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Cherry Tomatoes: {x.varValue} units")
        print(f"Cocktail Tomatoes: {y.varValue} units")
        print(f"Minimum Cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The model status is not optimal or infeasible.")

solve_tomato_paste_problem()
