
import gurobipy as gp

# Create a new model
m = gp.Model("wine_production")

# Create decision variables
x1 = m.addVar(lb=0, name="x1") # Regular wine
x2 = m.addVar(lb=0, name="x2") # Premium wine

# Set objective function
m.setObjective(20*x1 + 50*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 80, "demand_regular")
m.addConstr(x2 <= 50, "demand_premium")
m.addConstr(x1 + x2 <= 120, "supply")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Regular wine bottles: {x1.x:.0f}")
    print(f"Premium wine bottles: {x2.x:.0f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

