
from gurobipy import *

# Create a new model
m = Model("WineProduction")

# Define the decision variables
x1 = m.addVar(name="RegularWine", lb=0)  # Number of bottles of regular wine
x2 = m.addVar(name="PremiumWine", lb=0)  # Number of bottles of premium wine

# Define the objective function: Maximize profit
m.setObjective(20*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 80, name="DemandRegular")  # Demand constraint for regular wine
m.addConstr(x2 <= 50, name="DemandPremium")  # Demand constraint for premium wine
m.addConstr(x1 + x2 <= 120, name="SupplyConstraint")  # Total supply constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x1.x} bottles of regular wine and {x2.x} bottles of premium wine.")
else:
    print("No optimal solution found.")
