
import gurobipy as gp

# Create a new model
m = gp.Model("Wine Production")

# Define decision variables
x1 = m.addVar(lb=0, name="Regular_Wine")
x2 = m.addVar(lb=0, name="Premium_Wine")

# Define objective function
m.setObjective(20*x1 + 50*x2, gp.GRB.MAXIMIZE)

# Add demand constraints
m.addConstr(x1 <= 80, name="Regular_Demand")
m.addConstr(x2 <= 50, name="Premium_Demand")

# Add supply constraint
m.addConstr(x1 + x2 <= 120, name="Supply")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Regular Wine: {x1.varValue} bottles")
    print(f"Premium Wine: {x2.varValue} bottles")
    print(f"Max Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
