
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Costume_Profit")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="policeman_costumes")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="fireman_costumes")

# Set objective function
model.setObjective(8*x + 10*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 15*y <= 3000, "budget_constraint")
model.addConstr(x + y <= 280, "demand_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Policeman Costumes: {x.x}")
    print(f"Number of Fireman Costumes: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

