
from gurobipy import *

# Create a new model
m = Model("Costume_Store_Profit")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="policeman_costumes")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fireman_costumes")

# Set the objective function to maximize profit
m.setObjective(8*x + 10*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 15*y <= 3000, "budget_constraint")
m.addConstr(x + y <= 280, "demand_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of policeman costumes: {x.x}")
    print(f"Number of fireman costumes: {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")

