
import gurobipy as gp

# Create a new model
model = gp.Model("Costume_Optimization")

# Decision variables
x = model.addVar(lb=0, name="Policeman_Costumes")
y = model.addVar(lb=0, name="Fireman_Costumes")

# Objective function: Maximize profit
model.setObjective(8*x + 10*y, gp.GRB.MAXIMIZE)

# Budget constraint
model.addConstraint(10*x + 15*y <= 3000)

# Demand constraint
model.addConstraint(x + y <= 280)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Policeman Costumes = {x.varValue}, Fireman Costumes = {y.varValue}")
    print(f"Max Profit: ${model.objVal}")
else:
    print("The model is infeasible.")
