
import gurobipy as gp

# Create a new model
model = gp.Model("BallProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="soccer_balls")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="basketballs")

# Set objective function
model.setObjective(4 * x + 5 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * x + 7 * y <= 700, "manufacturing_time")
model.addConstr(3 * x + 4 * y <= 500, "filling_time")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Soccer Balls: {x.x}")
    print(f"Number of Basketballs: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

