
import gurobi as gp

# Create a new model
model = gp.Model("soccer_basket_ball_production")

# Define variables
S = model.addVar(name="soccer_balls", lb=0, vtype=gp.GRB.INTEGER)
B = model.addVar(name="basket_balls", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(4 * S + 5 * B, sense=gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(5 * S + 7 * B <= 700, name="manufacturing_machine_time")
model.addConstr(3 * S + 4 * B <= 500, name="air_filling_time")

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Soccer Balls = {S.varValue}, Basket Balls = {B.varValue}")
    print(f"Max Profit: ${model.objVal}")
else:
    print("The model is infeasible or no solution is found.")
