
import gurobipy as gp

# Create a new model
model = gp.Model("Jewelry_Production")

# Create decision variables
s = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="sapphire_rings")
r = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="ruby_rings")

# Set objective function
model.setObjective(500*s + 400*r, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(s <= 10, "sapphire_limit")
model.addConstr(r <= 15, "ruby_limit")
model.addConstr(s + r <= 15, "jeweler_limit")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of sapphire rings: {s.x}")
    print(f"Number of ruby rings: {r.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

