
from gurobipy import *

# Create a new model
m = Model("JewelryCompany")

# Define the decision variables
S = m.addVar(vtype=GRB.CONTINUOUS, name="sapphire_rings", lb=0)
R = m.addVar(vtype=GRB.CONTINUOUS, name="ruby_rings", lb=0)

# Define the constraints
m.addConstr(S <= 10, "max_sapphire")
m.addConstr(R <= 15, "max_ruby")
m.addConstr(S + R <= 15, "master_jeweler")

# Define the objective function
m.setObjective(500*S + 400*R, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sapphire rings: {S.x}")
    print(f"Ruby rings: {R.x}")
    print(f"Total profit: ${500*S.x + 400*R.x:.2f}")
else:
    print("No optimal solution found")
