
import gurobi

def solve_jewelry_rings_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    S = model.addVar(lb=0, ub=10, name="Sapphire_Rings")
    R = model.addVar(lb=0, ub=15, name="Ruby_Rings")

    # Objective function: Maximize profit
    model.setObjective(500 * S + 400 * R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(S <= 10, name="Sapphire_Production_Limit")
    model.addConstr(R <= 15, name="Ruby_Production_Limit")
    model.addConstr(S + R <= 15, name="Master_Jeweler_Approval_Limit")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Sapphire Rings = {S.varValue}, Ruby Rings = {R.varValue}")
        print(f"Maximum Profit: ${500 * S.varValue + 400 * R.varValue}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_jewelry_rings_problem()
