
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("GemStoreProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="earrings")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="watches")

# Set objective function
model.setObjective(45*x + 70*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + 3.5*y <= 14, "heating_constraint")
model.addConstr(1.5*x + 2*y <= 10, "polishing_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"Number of Earrings: {x.x}")
    print(f"Number of Watches: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

