
from gurobipy import *

# Create a new model
m = Model("Gem Store Production")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Earrings")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Watches")

# Set the objective function: maximize profit
m.setObjective(45*x + 70*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 3.5*y <= 14, name="Heating Machine")
m.addConstr(1.5*x + 2*y <= 10, name="Polishing Machine")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal production: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
