
import gurobipy as gp

# Create a new model
model = gp.Model("Earrings_Watches")

# Define the decision variables
x = model.addVar(name="Earrings", lb=0, ub=None, obj=45)
y = model.addVar(name="Watches", lb=0, ub=None, obj=70)

# Define the constraints
heating_machine_constraint = model.addConstr(2 * x + 3.5 * y <= 14, name="Heating_Machine")
polishing_machine_constraint = model.addConstr(1.5 * x + 2 * y <= 10, name="Polishing_Machine")

# Set the objective function
model.setObjective(x.obj + y.obj, sense=gp.GRB.MAXIMIZE)

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Earrings: {x.varValue}")
    print(f"Watches: {y.varValue}")
    print(f"Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
