
import gurobipy as gp

# Create a new model
model = gp.Model("JuiceProduction")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="JuiceA")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="JuiceB")

# Set objective function
model.setObjective(5*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 15*y <= 2000, "RaspberryConstraint")
model.addConstr(10*x + 15*y <= 1500, "BlueberryConstraint")
model.addConstr(10*x + 5*y <= 1400, "BlackberryConstraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Juice A: {x.x}")
    print(f"  Juice B: {y.x}")
    print(f"  Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

