
from gurobipy import *

# Create a new model
m = Model("Juice_Production")

# Define variables
x_A = m.addVar(vtype=GRB.CONTINUOUS, name="Juice_A", lb=0)
x_B = m.addVar(vtype=GRB.CONTINUOUS, name="Juice_B", lb=0)

# Set the objective function
m.setObjective(5*x_A + 7*x_B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x_A + 15*x_B <= 2000, "Raspberries")
m.addConstr(10*x_A + 15*x_B <= 1500, "Blueberries")
m.addConstr(10*x_A + 5*x_B <= 1400, "Blackberries")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Juice A: {x_A.x}")
    print(f"Juice B: {x_B.x}")
    print(f"Total Profit: ${5*x_A.x + 7*x_B.x:.2f}")
else:
    print("No optimal solution found")
