
import gurobi

def solve_juice_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="Juice_A", lb=0, ub=gurobi.GRB.INFINITY, obj=5)
    y = model.addVar(name="Juice_B", lb=0, ub=gurobi.GRB.INFINITY, obj=7)

    # Raspberries constraint
    model.addConstr(20*x + 15*y <= 2000, name="Raspberries_Constraint")

    # Blueberries constraint
    model.addConstr(10*x + 15*y <= 1500, name="Blueberries_Constraint")

    # Blackberries constraint
    model.addConstr(10*x + 5*y <= 1400, name="Blackberries_Constraint")

    # Set the objective function
    model.setObjective(5*x + 7*y, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${5*x.varValue + 7*y.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_juice_problem()
