
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("burrito_optimization")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="x") # Mexican burritos
y = m.addVar(vtype=GRB.CONTINUOUS, name="y") # Korean burritos

# Set objective function
m.setObjective(7*x + 4.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x + 5*y <= 70, "cheese_constraint")
m.addConstr(8*x <= 60, "beans_constraint")
m.addConstr(5*y <= 45, "onions_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Mexican Burritos (x): {x.x}")
    print(f"Number of Korean Burritos (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

