
from gurobipy import *

# Create a new model
m = Model("Burrito_Profit")

# Define the decision variables
M = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mexican_Burritos")
K = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Korean_Burritos")

# Set the objective function
m.setObjective(7*M + 4.5*K, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*M + 5*K <= 70, "Cheese_Constraint")
m.addConstr(8*M <= 60, "Beans_Constraint")
m.addConstr(5*K <= 45, "Onions_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mexican Burritos: {M.x}")
    print(f"Korean Burritos: {K.x}")
    print(f"Maximum Profit: ${7*M.x + 4.5*K.x:.2f}")
else:
    print("No optimal solution found.")
