
import gurobi

def solve_burrito_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="Mexican_burritos", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="Korean_burritos", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(7 * x + 4.5 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * x + 5 * y <= 70, name="Cheese_Constraint")
    model.addConstr(8 * x <= 60, name="Beans_Constraint")
    model.addConstr(5 * y <= 45, name="Onions_Constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal:.2f}")
        print(f"Number of Mexican burritos: {x.varValue:.2f}")
        print(f"Number of Korean burritos: {y.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_burrito_problem()
