
import gurobipy as gp

# Create a new model
m = gp.Model("TechCompanyProduction")

# Create decision variables
x = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laptops") # Number of laptops
y = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tablets") # Number of tablets

# Set objective function
m.setObjective(200*x + 160*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 15*y <= 1200, "manufacturing_time")
m.addConstr(3*x + 2*y <= 150, "silicon_availability")
m.addConstr(x >= 30, "min_laptops")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of laptops to produce: {x.x}")
    print(f"Number of tablets to produce: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

