
from gurobipy import *

# Create a new model
m = Model("Laptop_Tablet_Production")

# Define variables
x = m.addVar(lb=30, vtype=GRB.INTEGER, name="laptops")  # Number of laptops produced
y = m.addVar(vtype=GRB.INTEGER, name="tablets")  # Number of tablets produced

# Objective function: Maximize profit
m.setObjective(200*x + 160*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x + 15*y <= 1200, "manufacturing_time")
m.addConstr(3*x + 2*y <= 150, "silicon_availability")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x.x} laptops and {y.x} tablets.")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
