
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(lb=30, name="Laptops")  # At least 30 laptops
    T = model.addVar(lb=0, name="Tablets")   # Non-negative number of tablets

    # Objective function: Maximize profit
    model.setObjective(200*L + 160*T, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*L + 15*T <= 1200, name="Manufacturing_Time")
    model.addConstr(3*L + 2*T <= 150, name="Silicon_Availability")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Laptops: {L.varValue}, Tablets: {T.varValue}")
        return L.varValue, T.varValue
    else:
        print("No optimal solution found.")
        return None

# Execute the function
if __name__ == "__main__":
    solve_optimization_problem()
