
from gurobipy import Model, GRB

# Create a new model
m = Model("Flower_Profit")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="daisies")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peonies")

# Set objective function
m.setObjective(150 * x + 180 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 55, "land")
m.addConstr(4.5 * x + 7 * y <= 200, "nutrition")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Daisies: {x.x}")
    print(f"Acres of Peonies: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

