
from gurobipy import *

# Create a new model
m = Model("Hudson_Flowers")

# Define the variables
d = m.addVar(lb=0, name="daisies")
p = m.addVar(lb=0, name="peonies")

# Set the objective function: Maximize profit
m.setObjective(150*d + 180*p, GRB.MAXIMIZE)

# Add constraints
m.addConstr(d + p <= 55, name="land_constraint")  # Land constraint
m.addConstr(4.5*d + 7*p <= 200, name="nutrition_constraint")  # Plant nutrition constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grow {d.x} acres of daisies")
    print(f"Grow {p.x} acres of peonies")
    print(f"Total profit: ${m.objVal}")
else:
    print("No optimal solution found")

