
import gurobi as gp

# Create a new model
model = gp.Model("Hudson_Flower_Optimization")

# Define the variables
D = model.addVar(name="Daisies", lb=0)  # Acres for daisies
P = model.addVar(name="Peonies", lb=0)  # Acres for peonies

# Objective function: Maximize profit
model.setObjective(150 * D + 180 * P, gp.GRB.MAXIMIZE)

# Land constraint
model.addConstr(D + P <= 55, name="Land_Constraint")

# Plant nutrition constraint
model.addConstr(4.5 * D + 7 * P <= 200, name="Nutrition_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres for daisies: {D.varValue}")
    print(f"Optimal acres for peonies: {P.varValue}")
    print(f"Maximal profit: ${model.objVal:.2f}")
else:
    print("The problem is infeasible.")
