
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wooden_utensils")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="plates") # Number of plates
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="forks")  # Number of forks

# Set objective function
m.setObjective(10*x + 8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 20*y <= 5000, "woodworker_time")
m.addConstr(y >= 2*x, "fork_production")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of plates to produce: {x.x}")
    print(f"Number of forks to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

