
from gurobipy import *

# Create a new model
m = Model("Wooden Plates and Forks")

# Define the decision variables
P = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Plates")
F = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Forks")

# Set the objective function: Maximize profit
m.setObjective(10*P + 8*F, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*P + 20*F <= 5000, "Time constraint")
m.addConstr(F >= 2*P, "Forks to plates ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Plates = {P.x}, Forks = {F.x}")
    print(f"Maximum profit: ${10*P.x + 8*F.x:.2f}")
else:
    print("No optimal solution found")
