
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Plates")
    F = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Forks")

    # Objective function: Maximize profit
    model.setObjective(10*P + 8*F, gurobi.GRB.MAXIMIZE)

    # Woodworker time constraint
    model.addConstr(30*P + 20*F <= 5000, name="Woodworker_Time")

    # Forks to plates ratio constraint
    model.addConstr(F >= 2*P, name="Forks_to_Plates")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of plates: {P.varValue}")
        print(f"Optimal number of forks: {F.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_optimization_problem()
