
import gurobipy as gp

# Create a new model
model = gp.Model("SausageMixture")

# Create decision variables
x = model.addVar(lb=0, name="shrimp")  # Kilograms of shrimp
y = model.addVar(lb=0, name="beef")  # Kilograms of beef

# Set objective function
model.setObjective(36*x + 40*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2.5*x + 4*y >= 20, "protein_req")
model.addConstr(3*x + 2.5*y >= 25, "fat_req")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Kilograms of shrimp: {x.x:.2f}")
    print(f"Kilograms of beef: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

