
from gurobipy import *

# Create a new model
m = Model("Sausage_Mixture")

# Define the decision variables
x_s = m.addVar(lb=0, name="shrimp")  # Amount of shrimp in kg
x_b = m.addVar(lb=0, name="beef")    # Amount of beef in kg

# Define the objective function: Minimize total cost
m.setObjective(36*x_s + 40*x_b, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.5*x_s + 4*x_b >= 20, name="protein_constraint")
m.addConstr(3*x_s + 2.5*x_b >= 25, name="fat_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Shrimp (kg): {x_s.x}")
    print(f"Beef (kg): {x_b.x}")
    print(f"Total Cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
