
import gurobi

def solve_sausage_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(name="shrimp", lb=0, ub=None)
    y = model.addVar(name="beef", lb=0, ub=None)

    # Define the objective function
    model.setObjective(36 * x + 40 * y, sense=gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(2.5 * x + 4 * y >= 20, name="protein_requirement")
    model.addConstr(3 * x + 2.5 * y >= 25, name="fat_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is feasible
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Shrimp: {x.varValue} kg")
        print(f"Beef: {y.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution found.")
    else:
        print("Optimization failed.")

solve_sausage_problem()
