
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("ChairProduction")

# Create decision variables
leather_chairs = model.addVar(vtype=GRB.INTEGER, name="leather_chairs")
mesh_chairs = model.addVar(vtype=GRB.INTEGER, name="mesh_chairs")

# Set objective function
model.setObjective(150 * leather_chairs + 100 * mesh_chairs, GRB.MAXIMIZE)

# Add constraints
model.addConstr(leather_chairs <= 20, "TeamA_Capacity")
model.addConstr(mesh_chairs <= 30, "TeamB_Capacity")
model.addConstr(leather_chairs + mesh_chairs <= 30, "Quality_Check_Capacity")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Leather Chairs: {leather_chairs.x}")
    print(f"Mesh Chairs: {mesh_chairs.x}")
    print(f"Total Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

