
from gurobipy import *

# Create a model
m = Model("Office_Chair_Production")

# Define variables
L = m.addVar(lb=0, vtype=GRB.INTEGER, name="Leather_Chairs")
M = m.addVar(lb=0, vtype=GRB.INTEGER, name="Mesh_Chairs")

# Set objective function: Maximize profit
m.setObjective(150*L + 100*M, GRB.MAXIMIZE)

# Add constraints
m.addConstr(L <= 20, "Team_A_Capacity")
m.addConstr(M <= 30, "Team_B_Capacity")
m.addConstr(L + M <= 30, "Quality_Checking_Capacity")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Leather Chairs: {L.x}")
    print(f"Mesh Chairs: {M.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
