
import gurobi

def solve_chair_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(lb=0, ub=20, name="Leather_Chairs")
    M = model.addVar(lb=0, ub=30, name="Mesh_Chairs")

    # Objective function: Maximize profit
    model.setObjective(150*L + 100*M, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(L <= 20, name="Leather_Production_Limit")
    model.addConstr(M <= 30, name="Mesh_Production_Limit")
    model.addConstr(L + M <= 30, name="Quality_Checking_Capacity")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of leather chairs: {L.varValue}")
        print(f"Optimal number of mesh chairs: {M.varValue}")
        print(f"Maximal profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_chair_production()
