
import gurobipy as gp

# Create a new model
m = gp.Model("cutlery_optimization")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="spoons")
y = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="forks")
z = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knives")

# Set objective function
m.setObjective(2*x + 3*y + 4*z, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x + 1.5*y + 2*z <= 400, "steel_constraint")
m.addConstr(2*x + 1.5*y + 1*z <= 500, "rubber_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Number of spoons: {x.x}")
    print(f"Number of forks: {y.x}")
    print(f"Number of knives: {z.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

