
from gurobipy import *

# Create a new model
m = Model("Kitchen_Company")

# Define the decision variables
x_s = m.addVar(name="spoons", vtype=GRB.CONTINUOUS, lb=0)
x_f = m.addVar(name="forks", vtype=GRB.CONTINUOUS, lb=0)
x_k = m.addVar(name="knives", vtype=GRB.CONTINUOUS, lb=0)

# Define the objective function
m.setObjective(2*x_s + 3*x_f + 4*x_k, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_s + 1.5*x_f + 2*x_k <= 400, name="steel")
m.addConstr(2*x_s + 1.5*x_f + x_k <= 500, name="rubber")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x_s.varName} = {x_s.x}, {x_f.varName} = {x_f.x}, {x_k.varName} = {x_k.x}")
    print(f"Maximum revenue: {m.objVal}")
else:
    print("No optimal solution found")
