
import gurobi

def maximize_revenue():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(name="Spoons", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    F = model.addVar(name="Forks", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    K = model.addVar(name="Knives", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 2S + 3F + 4K
    model.setObjective(2 * S + 3 * F + 4 * K, gurobi.GRB.MAXIMIZE)

    # Steel constraint: S + 1.5F + 2K <= 400
    model.addConstr(S + 1.5 * F + 2 * K <= 400, name="Steel_Constraint")

    # Rubber constraint: 2S + 1.5F + K <= 500
    model.addConstr(2 * S + 1.5 * F + K <= 500, name="Rubber_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Spoons: {S.varValue}")
        print(f"Forks: {F.varValue}")
        print(f"Knives: {K.varValue}")
        print(f"Max Revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

maximize_revenue()
