
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x") # Sandwich A
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="y") # Sandwich B


# Set objective function
model.setObjective(5*x + 6*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 5*y <= 500, "cheddar_constraint")
model.addConstr(3*x + 2*y <= 400, "american_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Sandwich A: {x.x}")
    print(f"Number of Sandwich B: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

