
from gurobipy import *

# Create a model
m = Model("Sandwich_Optimization")

# Define variables
x_A = m.addVar(name="Sandwich_A", lb=0)
x_B = m.addVar(name="Sandwich_B", lb=0)

# Set the objective function
m.setObjective(5*x_A + 6*x_B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x_A + 5*x_B <= 500, name="Cheddar_Cheese_Constraint")
m.addConstr(3*x_A + 2*x_B <= 400, name="American_Cheese_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Sandwich A: {x_A.x}")
    print(f"Number of Sandwich B: {x_B.x}")
    print(f"Total Profit: ${5*x_A.x + 6*x_B.x:.2f}")
else:
    print("No optimal solution found.")
