
import gurobipy as gp

# Create a new model
m = gp.Model("Sandwich_Shop")

# Define the decision variables
x = m.addVar(name="Sandwich_A", lb=0, ub=None, obj=5)
y = m.addVar(name="Sandwich_B", lb=0, ub=None, obj=6)

# Add constraints
m.addConstr(3*x + 5*y <= 500, name="Cheddar_Cheese")
m.addConstr(3*x + 2*y <= 400, name="American_Cheese")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB_OPTIMAL:
    print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
    print(f"Maximum profit: ${5*x.varValue + 6*y.varValue:.2f}")
else:
    print("No optimal solution found")
