
from gurobipy import *

# Create a model
m = Model("Hotel_Staffing")

# Define the decision variables
C = m.addVar(vtype=GRB.INTEGER, name="cleaners")
R = m.addVar(vtype=GRB.INTEGER, name="receptionists")

# Set the objective function to minimize the wage bill
m.setObjective(500*C + 350*R, GRB.MINIMIZE)

# Add constraints
m.addConstr(C + R >= 100, "total_workers")
m.addConstr(R >= 20, "min_receptionists")
m.addConstr(R >= (1/3)*C, "receptionist_to_cleaner_ratio")
m.addConstr(500*C + 350*R <= 30000, "max_wage_bill")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cleaners: {C.x}")
    print(f"Number of receptionists: {R.x}")
    print(f"Total wage bill: ${500*C.x + 350*R.x}")
else:
    print("No optimal solution found")
