
import gurobi

def hotel_staffing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(lb=0, name="Cleaners", vtype=gurobi.GRB.INTEGER)
    R = model.addVar(lb=0, name="Receptionists", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize the wage bill
    model.setObjective(500*C + 350*R, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(C + R >= 100, name="Min_Total_Workers")
    model.addConstr(R >= 20, name="Min_Receptionists")
    model.addConstr(R >= C/3, name="Receptionists_to_Cleaners_Ratio")
    model.addConstr(500*C + 350*R <= 30000, name="Max_Wage_Bill")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cleaners: {C.varValue}")
        print(f"Receptionists: {R.varValue}")
        print(f"Minimum Wage Bill: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    hotel_staffing_problem()
