
from gurobipy import Model, GRB

# Create a new model
m = Model("cruise_ship_optimization")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="luxury_tickets")
y = m.addVar(vtype=GRB.INTEGER, name="regular_tickets")

# Set objective function
m.setObjective(500*x + 300*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 500, "capacity")
m.addConstr(x >= 100, "min_luxury")
m.addConstr(y >= 2*x, "regular_demand")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Luxury Tickets (x): {x.x}")
    print(f"Regular Tickets (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

