
from gurobipy import *

# Create a new model
m = Model("Cruise Ship Ticket Optimization")

# Define the decision variables
L = m.addVar(lb=0, vtype=GRB.INTEGER, name="Luxury_Tickets")
R = m.addVar(lb=0, vtype=GRB.INTEGER, name="Regular_Tickets")

# Set the objective function to maximize profit
m.setObjective(500*L + 300*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(L + R <= 500, "Total_Passengers")
m.addConstr(L >= 100, "Minimum_Luxury_Tickets")
m.addConstr(R >= 2*L, "Regular_vs_Luxury_Tickets")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Luxury Tickets: {L.x}")
    print(f"Regular Tickets: {R.x}")
    print(f"Maximum Profit: ${500*L.x + 300*R.x}")
else:
    print("No optimal solution found")
