
import gurobi

def solve_cruise_ship_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    L = model.addVar(lb=100, name="Luxury_Tickets")  # At least 100 luxury tickets
    R = model.addVar(name="Regular_Tickets")

    # Objective function: Maximize profit
    model.setObjective(500*L + 300*R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(L + R <= 500, name="Total_Passengers")  # Total passengers cannot exceed 500
    model.addConstr(R >= 2*L, name="Regular_vs_Luxury")  # At least 2 times as many regular tickets as luxury tickets

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Luxury Tickets = {L.varValue}, Regular Tickets = {R.varValue}")
        print(f"Maximum Profit: ${500*L.varValue + 300*R.varValue}")
    else:
        print("The model is infeasible")

solve_cruise_ship_ticket_problem()
