
import gurobipy as gp

# Create a new model
model = gp.Model("IceCreamOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberry_cakes")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mint_cakes")

# Set objective function
model.setObjective(2.5 * x + 4 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 10, "strawberry_min")
model.addConstr(x <= 20, "strawberry_max")
model.addConstr(y >= 20, "mint_min")
model.addConstr(y <= 40, "mint_max")
model.addConstr(x + y <= 50, "total_max")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of strawberry cakes: {x.x}")
    print(f"Number of mint cakes: {y.x}")
    print(f"Maximum profit: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

